﻿package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	public class survival extends Sprite {
		public var ground:ground_mc = new ground_mc();
		public var environment:environment_mc = new environment_mc();
		public var player:player_mc = new player_mc();
		public var light:Sprite=new Sprite  ;
		public var key_pressed:int=0;
		public var radius:int=8;
		public var player_speed:int=2;
		public var torch_power:int=100;
		public var torch_step:int=100;
		public var torch_angle:int=60;
		public var torch_angle_step:int=20;
		public var up,down,left,right:Boolean=false;
		public var flicker=20;
		public function survival():void {
			addChild(ground);
			addChild(environment);
			addChild(light);
			addChild(player);
			player.x=250;
			player.y=200;
			ground.mask=light;
			addEventListener(Event.ENTER_FRAME,on_enter_frame);
			stage.addEventListener(KeyboardEvent.KEY_DOWN, on_key_down);
			stage.addEventListener(KeyboardEvent.KEY_UP, on_key_up);
		}
		public function on_enter_frame(e:Event):void {
			if (up) {
				player.y-=player_speed;
			}
			if (down) {
				player.y+=player_speed;
			}
			if (left) {
				player.x-=player_speed;
			}
			if (right) {
				player.x+=player_speed;
			}
			while (environment.hitTestPoint(player.x, player.y+radius, true)) {
				player.y--;
			}
			while (environment.hitTestPoint(player.x, player.y-radius, true)) {
				player.y++;
			}
			while (environment.hitTestPoint(player.x-radius, player.y, true)) {
				player.x++;
			}
			while (environment.hitTestPoint(player.x+radius, player.y, true)) {
				player.x--;
			}
			var dist_x:Number=player.x-mouseX;
			var dist_y:Number=player.y-mouseY;
			var angle:Number=- Math.atan2(dist_x,dist_y);
			player.rotation=to_degrees(angle);
			light.graphics.clear();
			if (Math.random()*100>flicker) {
				light.graphics.beginFill(0xffffff, 100);
				light.graphics.moveTo(player.x, player.y);
				for (var i:int=0; i<=torch_angle; i+=(torch_angle/torch_angle_step)) {
					ray_angle = to_radians((to_degrees(angle)-90-(torch_angle/2)+i));
					for (var j:int=1; j<=torch_step; j++) {
						if (environment.hitTestPoint(player.x+(torch_power/torch_step*j)*Math.cos(ray_angle), player.y+(torch_power/torch_step*j)*Math.sin(ray_angle), true)) {
							break;
						}
					}
					light.graphics.lineTo(player.x+(torch_power/torch_step*j)*Math.cos(ray_angle), player.y+(torch_power/torch_step*j)*Math.sin(ray_angle));
				}
				light.graphics.lineTo(player.x, player.y);
				light.graphics.endFill();
			}
		}
		public function on_key_down(e:KeyboardEvent):void {
			switch (e.keyCode) {
				case 37 :
					left=true;
					break;
				case 38 :
					up=true;
					break;
				case 39 :
					right=true;
					break;
				case 40 :
					down=true;
					break;
				case 49 :
					torch_power++;
					break;
				case 50 :
					torch_power--;
					break;
			}
		}
		public function on_key_up(e:KeyboardEvent):void {
			switch (e.keyCode) {
				case 37 :
					left=false;
					break;
				case 38 :
					up=false;
					break;
				case 39 :
					right=false;
					break;
				case 40 :
					down=false;
					break;
			}
		}
		public function to_radians(n:Number):Number {
			return (n*0.0174532925);
		}
		public function to_degrees(n:Number):Number {
			return (n*57.2957795);
		}
	}
}